﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;
using ZSMusic.Model;

namespace WEB.musicspy
{
    [Serializable]
    public class SongResult
    {
        public static string Address { get { return ConfigurationManager.AppSettings["Address"]; } }
        public string SongId { get; set; }
        public string SongName { get; set; }
        public string SubTitle { get; set; }
        public string Artist { get; set; }
        public string ArtistSubTitle { get; set; }
        public string AlbumId { get; set; }
        public string Album { get; set; }
        public string AlbumSubTitle { get; set; }
        public string AlbumArtist { get; set; }
        public string CollectName { get; set; }
        public string Length { get; set; }
        public string Size { get; set; }
        public string BitRate { get; set; }
        public string FlacUrl { get; set; }
        public string AacUrl { get; set; }
        public string SqUrl { get; set; }
        public string HqUrl { get; set; }
        public string LqUrl { get; set; }
        public string ListenUrl { get; set; }
        public string CopyUrl { get; set; }
        public string PicUrl { get; set; }
        public string LrcUrl { get; set; }
        public string KlokLrc { get; set; }
        public string MvId { get; set; }
        public string MvUrl { get; set; }
        public string VideoUrl { get; set; }
        public string Language { get; set; }
        public string Company { get; set; }
        public string Year { get; set; }
        public string Disc { get; set; }
        public string TrackNum { get; set; }
        public string Type { get; set; }
        public SongResult(Music m)
        {
            SongId = m.Id;
            SongName = m.Name;
            CollectName = m.Name;
            SubTitle = m.Name;
            Artist = m.Artist;
            Album = m.Album;
            AlbumArtist = m.Artist;
            AlbumId = m.AlbumId;
            string url = string.Format("http://{0}/getdata.aspx?source={1}&id={2}&name={3}&artist={4}&album={5}&albumid={6}&type=url&redirect=1", Address, m.Source, m.Id, m.Name, m.Artist, m.Album, m.AlbumId);
            ListenUrl = url;
            LqUrl = url;
            CopyUrl = url;
            LrcUrl = string.Format("http://{0}/getdata.aspx?source={1}&id={2}&name={3}&artist={4}&album={5}&albumid={6}&type=lrc&redirect=1", Address, m.Source, m.Id, m.Name, m.Artist, m.Album, m.AlbumId);
            Type = m.Source;
            PicUrl = string.Format("http://{0}/getdata.aspx?source={1}&id={2}&name={3}&artist={4}&album={5}&albumid={6}&type=pic&redirect=1", Address, m.Source, m.Id, m.Name, m.Artist, m.Album, m.AlbumId);
            TrackNum = m.Id;
        }
        public static List<SongResult> Convert(List<Music> list)
        {
            List<SongResult> result = new List<SongResult>();
            foreach (var item in list)
            {
                result.Add(new SongResult(item));
            }
            return result;
        }
        public SongResult() { }
    }
}